SIMPLEserial <- function (c, presTime, recTime, J) {
# c is the single parameter of SIMPLE
# presTime and recTime are the effective temporal
# separation of items at input and output
# J is the length of the list

    pcor <- rep.int(0,J)
    Ti <- cumsum(rep.int(presTime,J))
    Tr <- Ti[length(Ti)] + cumsum(rep.int(recTime,J))

    for (i in c(1:J)) { #i indexes output + probe position
        M <- log(Tr[i]-Ti)
        eta <- exp(-c*abs(M[i]-M))
        pcor[i] <- 1/sum(eta)
       }
   return(pcor)
}