#setwd("C:\\Users\\lewan\\Documents\\Papers Written\\Modeling Book\\THEChapters\\Chapter5-Model_selection\\R4Chapter5")

myHessianExample <- function() { 

source("Listing_5_2.r")  #make sure the required functions are available

N <- 100
data <- rnorm (N, 500, 65) + rexp(N, 1/100)  #note: argument is inverse of mean


# find MLEs for ex-Gaussian parameters
startParms <- c(500, 65, 100)
xout <- optim(startParms, exGausslnL2, gr=NULL, method="Nelder-Mead", y=data) #use N-M to be equivalent to fminsearch
print(xout) #print results

# find Hessian for MLEs
hess <- hessian(exGausslnL2, xout$par, 10^-3, data) #note: this step is unnecessary in R because optim could 
    #be called with the hessian=TRUE option and a Hessian could be obtained directly. However, for pedagogical reasons,
    #the entire MatLab code is translated into R even though part of it (i.e., Listing 5.2) would not be necessary.
cov <- solve(hess)
print(hess)
print(cov)
}

#another version of exGausslnL
exGausslnL2 <- function (theta, y) {
    erf <- function(x) 2 * pnorm(x * sqrt(2)) - 1  #cludgy but retains identity of next statement with MatLab
    mu    <- theta[1]
    sigma <- theta[2]
    tau   <- theta[3]
    rootTwo <- sqrt(2)
    
    fval <- log(1/tau)+
    (((mu-y)/tau)+((sigma^2)/(2*tau^2))) + log(.5) + log(1+erf((((y-mu)/sigma)-(sigma/tau))/rootTwo))
    return(-sum(fval)) # turn into a summed negative log-likelihood for minimization
    } 




