witness <- function(parms) {
# Implementation of the WITNESS model for
# "Computational Modeling in Cognition: Principles and Practice"


set.seed(consts$seed)       #access global variable and reset random number generator

s    <- parms[1]                
sim  <- parms[2]
ssp  <- sim
paSim<- sim
ppSim<- sim            

predictions <- matrix(0,consts$nCond, 3)
paLineup    <- matrix(0,consts$lSize,consts$n)
ppLineup    <- matrix(0,consts$lSize,consts$n)

for (reps in 1:consts$nRep){   
    #obtain perpetrator and perform holdup
    perp <- getvec(consts$n)
    m    <- storevec (s, perp)  
    
    #get an innocent suspect
    inSus <-getsimvec(ssp, perp)  
    
    #create both types of lineup
    paLineup [1, ] <- inSus     
    ppLineup [1, ] <- perp   
    for (i in 2:consts$lSize) {  
        paLineup [i, ] <-  getsimvec (paSim, perp)
        ppLineup [i, ] <-  getsimvec (ppSim, perp)
    }
    
    #eyewitness inspects lineup
    paMatch <- apply(paLineup,1,FUN=function(x) x %*% m)
    ppMatch <- apply(ppLineup,1,FUN=function(x) x %*% m)
    
    #witness responds
    for (iLineup in 1:consts$nCond){   
        if (iLineup %in% consts$fChoice) {
            criterion<-0 
           } else {
            criterion<-parms[consts$ptToCrit[iLineup]]   
           }
        if (iLineup %in% consts$paLineup) {
            useMatch <- paMatch
           } else {
            useMatch <- ppMatch
           }
        resp <- decision (useMatch, criterion)
        predictions[iLineup, resp] <- predictions[iLineup, resp] + 1   
       }              
    } #rep loop
return(predictions/consts$nRep)  
}
