GRTlnL <- function (theta, x, data, N) {
# gives the negative log-likelihood
# for response frequencies from a single participant (data)
# given the GRT parameters (in vector theta),
# the stimulus values in x,
# the number of times `A' was selected as a response (data)
# and the total number of test trials for each stimulus (N)

bound1 <- theta[1]
bound2 <- theta[2]

if (bound1 >= bound2) {
    lnL <- .Machine$double.xmax
    predP <<- rep.int(NaN, length(N)) #use global variable to record predictions because optim expects only one value returned
    return (lnL)
   }

sd <- theta[3]

a1 <- pnorm((bound1-x)/sd)          #normalCDF needs not be written explicitly in R
a2 <- 1 - pnorm((bound2-x)/sd) 
predP <<- a1 + a2

lnL <- -sum(data*log(predP) + (N-data)*log(1-predP))
return (lnL)
}
