# (R) Implementation of the phonological loop for 
# Lewandowsky and Farrell's
# "Computational Modeling in Cognition: Principles and Practice"
# Sage publishing.
rm(list=ls())

nReps <- 1000       #number of replications

listLength <- 5     #number of list items
initAct <- 1        #initial activation of items
decRate <- .8       #mean decay rate (per second)
decSD  <- .1        #standard deviation of decay rate
delay <- 5          #retention interval (seconds)
minAct <- .0        #minimum activation for recall  

rRange <- seq(from=1.5, to=4., length.out=15);   
tRange <- 1/rRange;
pCor <- rep.int(0,length(rRange));

i <- 1;                #index for word lengths
for (tPerWord in tRange) {
    for (rep in 1:nReps) {
        actVals <- rep.int(1,listLength)*initAct  
        dRate <- decRate + rnorm(1,0,decSD)

        cT <- 0
        itemReh <- 0 # start rehearsal
                     # with beginning of list
        while (cT < delay) {
            intact <- which(actVals>minAct)
            # find the next item still accessible
            itemReh <- intact[which(intact>itemReh)[1] ] 
            # rehearse or return to beginning of list
            if (is.na(itemReh)) {
                itemReh <- 1
               }
            actVals[itemReh] <- initAct
            # everything decays
            actVals <- actVals - (dRate*tPerWord)
            cT <- cT + tPerWord 
           }
        pCor[i] = pCor[i] + (sum(actVals>minAct)/listLength); 
      }
    i<-i+1
   }

plot(rRange,pCor/nReps, pch=19, xlim=c(0,4.5), ylim=c(0,1), las=1,
     ylab="Proportion Correct", xlab="Speech Rate")
