#setwd("C:\\Users\\lewan\\Documents\\Papers Written\\Modeling Book\\THEChapters\\Chapter4-Maximum_likelihood_estimation\\R4Chapter4")

source ("Listing_4_3.r")  #need to make sure binomPDF is available

SIMPLEserialBinoPMF <- function(c, presTime, recTime, J, Nc, N) {
# c is the parameter of SIMPLE
# presTime and recTime are the effective temporal
# separation of items at input and output
# J is the length of the list
# Nc (a vector) is the number of items correctly recalled at each position
# N is the number of trials at each position

  pmf <- rep.int(0,J)
  Ti <- cumsum(rep.int(presTime,J))
  Tr = Ti[length(Ti)] + cumsum(rep.int(recTime,J))

  for (i in c(1:J)) {
     M <- log(Tr[i]-Ti)
     eta <- exp(-c*abs(M[i]-M))
     pcor <- 1/sum(eta) 
     pmf[i] <- binomPMF(Nc[i], N, pcor)
    }
  return(pmf)
}
