#setwd("C:\\Users\\lewan\\Documents\\Papers Written\\Modeling Book\\THEChapters\\Chapter4-Maximum_likelihood_estimation\\R4Chapter4")

require(lattice)  #for 3D surfaces
source ("Listing_4_1.r")  #need to make sure exGaussPDF is available

mMu <- 5 
mTau<- 5
muN<-50 
tauN<-50 #range and resolution of points along each dimension
mu <-  seq(from=0,to=mMu, length.out=muN)
tau <- seq(from=0,to=mTau,length.out=tauN)

rt <- c(3, 4, 4, 4, 4, 5, 5, 6, 6, 7, 8, 9)

lsurf <- matrix(0, tauN, muN)
lnLsurf <- matrix(0, tauN, muN)
# nested loops across mu and tau
# calculate a joint likelihood for each parameter combination
i<-1
for (muloop in mu) {
    j<-1
    for (tauloop in tau) {
        lsurf[j,i]<- prod(exGaussPDF(rt,muloop, .1, tauloop))
        lnLsurf[j,i] <- sum(log(exGaussPDF(rt,muloop, .1, tauloop)))
        j<-j+1
    }
    i<-i+1
}


#likelihood surface
x11()
g<-expand.grid(x=mu,y=tau)
g$z<-c(lsurf)
wireframe(z ~ x*y, data=g, scales=list(arrows=FALSE),xlab="mu",ylab="tau",zlab="L")
          
          
#log likelihood surface
x11()
g$z<-c(lnLsurf)
wireframe(z ~ x*y, data=g, scales=list(arrows=FALSE),xlab="mu",ylab="tau",zlab="lnL")
