SIMPLEmultinomLnL <- function(c, alpha, presTime, recTime, J, k) {
# c and alpha are the two parameters of SIMPLE
# presTime and recTime are the effective temporal
#    separation of items at input and output
# J is the length of the list
# k is a matrix; each row i corresponds to an output position,
#    and element j in the row gives the number of times
#    item j was recalled at position i

  lnL <- rep.int(0,J)
  Ti <- cumsum(rep.int(presTime,J))
  Tr = Ti[length(Ti)] + cumsum(rep.int(recTime,J))

  for (i in c(1:J)){
     M <- log(Tr[i]-Ti) 
     eta <- exp(-c*abs(M[i]-M)^alpha)
     pall <- eta/sum(eta)
     lnL[i] <- sum(k[i,]*log(pall))
    }
  return(lnL)
}