#setwd("C:\\Users\\lewan\\Documents\\Papers Written\\Modeling Book\\THEChapters\\Chapter5-Model_selection\\R4Chapter5")

hessian <- function(lnLfun, theta, delta, ...) {
# The argument lnLfun is the name of a function
# The function expects the free parameters to be 
#   provided in a single vector theta, 
#   and additional arguments (including the data)
#   can be passed in place of the '...'
# delta is the step size in the Hessian calculations

# e is the identity matrix multiplied by delta, and is used
#   to set up the e_i's and e_j's efficiently
#   we just select the appropriate row in the loop
lT <- length(theta)
e <- diag(lT)*delta
C <- matrix(0,lT,lT)
for (i in c(1:lT)) {
    for (j in c(1:lT)) {
        C[i,j] <- lnLfun (theta+e[i,]+e[j,], ...)-lnLfun (theta+e[i,]-e[j,], ...)-
                  lnLfun (theta-e[i,]+e[j,], ...)+lnLfun (theta-e[i,]-e[j,], ...)
        }
    }
    return(C/(4*(delta^2)))
}