bootstrapExample <- function() {

source("Listing_5_4.r")  
data <- c(40, 28, 13, 11, 11, 10, 6, 11, 17, 8, 14, 14, 13, 14, 22, 43, 53, 70, 71, 74)
N <- 80

# some assumed experimental parameters
Ti <- 1:20
Tr <- 30 # we assume retrieval time is fixed here

# information and initialization for the bootstrap procedure
bootSamples <- 1000
samplePhat <- matrix(0, nrow=bootSamples, ncol=3)

# MLE of parameters
xout <- optim(c(20.39, .64, 10.25), SIMPLEfreeBino, gr=NULL, 
              data=data, recTime=Tr, presTime=Ti, Ndp=N, method="Nelder-Mead") #use N-M to be equivalent to fminsearch

#predictions available in global variable p created by SIMPLEfreeBino
preds <- p   #archive it permanently so it doesn't get altered by next call to optim
                     
# now do the bootstrapping
for (i in c(1:bootSamples)) {
    if(i %% 100 == 0) {print(i)}
        
    sampData <- rbinom(length(p), N, preds)  #generate values from best-fitting estimates using binomial
    
    bootOut <- optim(xout$par, SIMPLEfreeBino, gr=NULL, method="Nelder-Mead", 
                     data=sampData, recTime=Tr, presTime=Ti, Ndp=N) 
    samplePhat[i,] <- bootOut$par 
   }
quants <- quantile(samplePhat,c(.025, .975))
return(samplePhat)
}