quickJacobian <- function(x, y, fname, ...) {
  Np <- length(x)
  Nd <- length(y)
  Jac <- matrix(0,Nd,Np)
  epsilon <- sqrt(.Machine$double.eps)

  # Iterate over parameters to estimate columns of 
  # Jacobian by finite differences.
  for (i in c(1:Np)) {
       x_offset <- x
       x_offset[i] <- x_offset[i] + epsilon

       # get model predictions for offset parameter vector.
       f_offset <- do.call(fname,list(x_offset, ...)) 
       
       Jac[,i] <- (f_offset - y)/epsilon        
   }
  return(Jac)
}