#------ miscellaneous embedded functions 
#get random vector
    getvec <- function (n) {
        return(runif(n)-0.5)
    }

#take a vector and return one of specified similarity
    getsimvec <- function(s, inVec) {
        a <- runif(length(inVec)) < s
        return( a*inVec  + (!a) * getvec(length(inVec)))
    }

#encode a vector in memory
    storevec <- function(s, inVec) {    
        return(getsimvec(s, inVec))
    }

#implement the decision rules
    decision <- function(matchValues, cRec) {
        #if all lineup members fall below cRec, then reject
        if (max(matchValues) < cRec) {   
            resp <- 3
        } else {
            j <- which.max(matchValues)
            resp <- ifelse(j == 1,1,2)    #suspect or perp always first  
          }
     return(resp)
    }