#setwd("C:\\Users\\lewan\\Documents\\Papers Written\\Modeling Book\\THEChapters\\Chapter7-Uses_of_models\\R4Chapter7")

# Program to estimate parameters for WITNESS 
# for Lewandowsky and Farrell's
# "Computational Modeling in Cognition: Principles and Practice"

rm(list=ls())

source ("Listing_7_1.r")  #make sure WITNESS function is loaded
source ("Listing_7_2.r")  #need to make sure auxiliary functions are available
source ("Listing_7_4.r")  #make sure bof function is loaded

consts <- list(
seed  = 2137,  #for random generator  
lSize = 6,     #lineup size
nRep  = 1000,   #number of reps at each call
n     = 100,       #number of features in vectors
nCond = 9,     #number of conditions modeled
fChoice = c(7, 8, 9),   #forced-choice conditions
paLineup = c(4, 5, 6),  #paLineup conditions
ptToCrit = c(3, 4, 5, 3, 4, 5), #slots in parameters  
maxParms = c(1., 1., Inf, Inf, Inf)
)

#Data Exp 1 & 2 of Clare & Lewandowsky (2004),
#columns are: Suspect, Foil, and Reject
datnum <- c(.80, .13, .07,    #PP control    
        .57, .06, .36,    #PP holistic
        .69, .12, .19,    #PP featural
        .05, .72, .23,    #PA control
        .20, .28, .52,    #PA holistic
        .00, .48, .52,    #PA featural
        .86, .14, .00,    #Exp 2 control
        .81, .19, .00,    #Exp 2 holistic
        .84, .16, .00)   #Exp 2 featural   
data <- matrix(datnum,ncol=3,byrow=TRUE)

#initialize parameters in order: 
#  s  
#  sim   
#  crec -control
#  crec -holistic 
#  crec -featural 
print("Starting values of parameters")
startParms <- c(0.2942,    0.3508,    1.0455,    2.0930,    1.8050)

xout <- optim(startParms, bof, gr=NULL, method="Nelder-Mead", y=data) #use N-M to be equivalent to fminsearch

#print final predictions
fp <- witness(xout$par)
print(fp)


