DEMlnL <- function(theta, x, feedback, data, N, fixG) {
# gives the negative log-likelihood
# for response frequencies from a single participant (data)
# given the DEM parameters (in vector theta), the stimulus values in x,
# the number of times each stimulus was an `A' in feedback
# the number of times `A' was selected as a response (data)
# and the total number of test trials for each stimulus (N)
# parameter fixG is required to switch between DEM and GCM

c <- theta[1]
gamma <- ifelse(fixG==1, 1, theta[2]) #decide on whether GCM or DEM

predP <<- rep.int(0,length(x)) #use global variable to record predictions because optim expects only one value returned

for (i in 1:length(x)) {
    s <- exp(-c*abs(x[i]-x))
    sumA <- sum(s*feedback[1, ])
    sumB <- sum(s*feedback[2, ])
    predP[i] <<- (sumA^gamma)/(sumA^gamma + sumB^gamma)
   }

lnL <- -sum(data*log(predP) + (N-data)*log(1-predP))
return(lnL)
}