#setwd("C:\\Users\\lewan\\Documents\\Papers Written\\Modeling Book\\THEChapters\\Chapter7-Uses_of_models\\R4Chapter7")

# script catModels
rm(list=ls())
require(stats)
require(MASS)

source ("Listing_7_6.r")  #make sure ....
source ("Listing_7_7.r")  #.... auxiliary functions are available
source ("Listing_5_2.r")  # including the Hessian function from Chapter 5
source ("Listing_5_6.r")  # including the infoCriteria function from Chapter 5

dataPnum <- 
  c(0.75,0.67,0.54,0.4,0.4,0.37,0.58,0.71,
    0.92,0.81,0.53,0.28,0.14,0.22,0.45,0.81,
    0.91,0.97,0.93,0.64,0.28,0.09,0.12,0.7,
    0.98,0.94,0.85,0.62,0.2,0.037,0.078,0.71,
    0.97,0.94,0.8,0.58,0.4,0.45,0.81,0.97,
    0.29,0.66,0.85,0.71,0.33,0.1,0.32,0.77)
dataP <- matrix(dataPnum,nrow=6,byrow=TRUE)
preds <- matrix(0,6,8)
theta <- matrix(0,6,3)
thetaSE <- matrix(0,6,3)
lnL <- rep.int(0,6)
pptLabels <- c("SB","SEH","VB","BG","NV","LT")


# number sessions x 10 blocks x 96 trials /(n stimuli)
Ntrain <- ((5*10*96)/8)
pfeedback <- c(.6, .6, 1, 1, 0, 0, .6, .6)
Afeedback <- pfeedback * Ntrain
feedback <- rbind(Afeedback, Ntrain-Afeedback)

Ntest <- ((3*10*96)/8)
N <- rep.int(Ntest,8)
dataF <- ceiling(Ntest*(dataP))

stimval <- seq(from=.0625, to=.9375, length.out=8)

## Maximum likelihood estimation
for (modelToFit in c("GCM","GRT","DEM")) {

    for (ppt in 1:6) {
        if (modelToFit=="GCM") {
            xGCM = nlminb(c(0) ,DEMlnL,gradient=NULL, x=stimval, feedback=feedback, data=dataF[ppt,], N=N, fixG=1,
                         lower=0, upper=100)
            DEMlnL(xGCM$par, stimval, feedback, dataF[ppt,], N, 1)
            theta[ppt,] <- c(xGCM$par, NaN, NaN)
            lnL[ppt] <- xGCM$objective
            preds[ppt,] <- predP  #recover global variable and save it
            
            hess <- hessian(DEMlnL,xGCM$par,10^-3, stimval, feedback, dataF[ppt,], N, 1)
            cov <- ginv(hess)
            thetaSE[ppt,] <- c(sqrt(diag(cov)),NaN,NaN)
        }
        
        if (modelToFit=="GRT") {       
            xGRT = nlminb( c(.3,.7,.1) ,GRTlnL, gradient=NULL, x=stimval, data=dataF[ppt,], N=N, 
                         lower=c(-1,-1,.Machine$double.eps),upper=c(2,2,10))
            GRTlnL(xGRT$par, stimval, dataF[ppt,], N)
            theta[ppt,] <- xGRT$par
            lnL[ppt] <- xGRT$objective
            preds[ppt,] <- predP  #recover global variable and save it
            
            hess <- hessian(GRTlnL,xGRT$par,10^-3, stimval, dataF[ppt,], N)
            cov <- ginv(hess)
            thetaSE[ppt,] <- sqrt(diag(cov))
        }
        
        if (modelToFit=="DEM") {
            xDEM = nlminb( c(5,1) ,DEMlnL,gr=NULL, x=stimval, feedback=feedback, data=dataF[ppt,], N=N, fixG=0,
                         lower=c(0,0), upper=c(Inf,Inf))
            DEMlnL(xDEM$par, stimval, feedback, dataF[ppt,], N, 0)
            theta[ppt,] <- c(xDEM$par, NaN)
            lnL[ppt] <- xDEM$objective
            preds[ppt,] <- predP  #recover global variable and save it      
            
            hess <- hessian(DEMlnL,xDEM$par,10^-3,stimval, feedback, dataF[ppt,], N, 0)
            cov <- ginv(hess)
            thetaSE[ppt,] <- c(sqrt(diag(cov)),NaN)
        }
                
    }  #end of ppt loop

    #do plotting
    x11()
    par(mfrow=c(2,3))
    for (ppt in 1:6) {
        plot   (stimval, dataP[ppt,], pch="+",ylim=c(0,1),xlab="P(A)",ylab="Luminance",type="b")
        points (stimval, preds[ppt,], pch="*")
        lines  (stimval, preds[ppt,], lty="dotdash")
        title(main=pptLabels[ppt])
    }
    
    switch(EXPR=modelToFit,
          GCM = GCM<-list(theta=theta, thetaSE=thetaSE, nlnL=lnL),
          GRT = GRT<-list(theta=theta, thetaSE=thetaSE, nlnL=lnL),
          DEM = DEM<-list(theta=theta, thetaSE=thetaSE, nlnL=lnL))
} #end of model loop

 
 for (ppt in 1:6){
     AIClist <- infoCriteria(c(GCM$nlnL[ppt], GRT$nlnL[ppt], DEM$nlnL[ppt]), c(1, 3, 2), rep.int(Ntest*8,3))
     print(AIClist)
 }
